<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Tables\Post;

use Erlage\Photogram\Data\Tables\AbstractTable;
use Erlage\Photogram\Data\Models\Post\Usertag\PostUserTagModel;

final class PostUserTagTable extends AbstractTable
{
    /*
    |--------------------------------------------------------------------------
    | table data
    |--------------------------------------------------------------------------
    */

    const TABLE_NAME = 'postusertag';

    /*
    |--------------------------------------------------------------------------
    | fields/attributes
    |--------------------------------------------------------------------------
    */

    const ID = 'id';

    // ids

    const TAGGED_USER_ID = 'tagged_user_id';

    const TAGGED_IN_POST_ID = 'tagged_in_post_id';

    const POST_OWNER_USER_ID = 'post_owner_user_id';

    // stamp

    const STAMP_REGISTRATION = 'stamp_registration';

    const STAMP_LAST_UPDATE = 'stamp_last_update';

    /*
    |--------------------------------------------------------------------------
    | table meta data
    |--------------------------------------------------------------------------
    */

    const OWNER_KEY = self::TAGGED_USER_ID;

    const PROTECTED_FIELDS_MAP = array();

    const PRIVATE_FIELDS_MAP = array();

    /*
    |--------------------------------------------------------------------------
    | all properties must provide their camel case equivalent
    |--------------------------------------------------------------------------
    */

    const CAMEL_CASE_MAP = array(
        self::ID => 'id',

        self::TAGGED_USER_ID     => 'taggedUserId',
        self::TAGGED_IN_POST_ID  => 'taggedInPostId',
        self::POST_OWNER_USER_ID => 'postOwnerUserId',

        self::STAMP_REGISTRATION => 'stampRegistration',
        self::STAMP_LAST_UPDATE  => 'stampLastUpdate',
    );

    /*
    |--------------------------------------------------------------------------
    | required attributes
    |--------------------------------------------------------------------------
    */

    public static function getPrimaryAttribute(): string
    {
        return self::ID;
    }

    public static function getRegistrationStampAttribute(): string
    {
        return self::STAMP_REGISTRATION;
    }

    public static function getLastUpdateStampAttribute(): string
    {
        return self::STAMP_LAST_UPDATE;
    }

    public static function getOwnerAttribute(): string
    {
        return self::TAGGED_USER_ID;
    }

    /*
    |--------------------------------------------------------------------------
    | meta getters
    |--------------------------------------------------------------------------
    */

    public static function getTableName(): string
    {
        return self::TABLE_NAME;
    }

    public static function getModelClassName(): string
    {
        return PostUserTagModel::erlClass();
    }

    /*
    |--------------------------------------------------------------------------
    | table properties getters
    |--------------------------------------------------------------------------
    */

    public static function allAttributes(): array
    {
        return self::CAMEL_CASE_MAP;
    }
}
